#!/usr/bin/env python
# encoding: utf-8


from blueflask.flask_api import FlaskApp

from ..consts import ADDRESS
from ..consts import APIGW
from ..consts import LOGS
from ..consts import HOSTNAME
from ..consts import SERVICE_CODE
from .v1 import api
from .v1 import __version__

import requests


flask_app = FlaskApp(SERVICE_CODE)
flask_app.produce_handlers_and_documentation()

app = flask_app.app
app.config['LOGGER_NAME'] = 'bluebase-services-api'
app.config['TITLE'] = 'API BLUEBASE'
app.config['DESCRIPTION'] = "Interactions avec l'API du serveur 4D"
app.config['VERSION'] = __version__
app.logger.handlers = LOGS.logger.handlers
app.register_blueprint(api)

requests.post(
    'https://{fqdn}/registry'.format(fqdn=APIGW),
    json={
        'service': 'bluebase',
        'address': ADDRESS,
        'version': int(eval(__version__)),
        'service_code': SERVICE_CODE,
        'host': HOSTNAME,
        'status': 'up'
        }
    )

if __name__ == '__main__':
    app.run(debug=True)

# EOF
