# -*- coding: utf-8 -*-

from .consts import CONFIG, LOGS

import requests
import xmltodict
import zeep


__all__ = [
    'Request'
    ]


class Request(object):

    """Représente une requête SOAP vers le serveur 4D"""

    def __init__(self, context, service, version=1, *args):
        self.ident = CONFIG['CONTEXT_{}'.format(context)]['ident']
        psw = CONFIG['CONTEXT_{}'.format(context)]['psw']  # may raise KeyError
        self.service = service
        self.params = args
        self.payload = {
            'root': {
                'header': {
                    'version': version,
                    'param1': self.service,
                    'ident': self.ident,
                    'psw': psw
                    },
                'data': {}
                }
            }
        if self.params:
            for index, value in enumerate(self.params):
                key = 'param{}'.format(index+2)
                self.payload['root']['header'][key] = value

    def append_data(self, data):
        self.payload['root']['data'] = data

    @property
    def xml(self):
        xml_in = xmltodict.unparse(self.payload)
        xml_in = xml_in.split('\n')[1]
        return xml_in

    def send(self):
        try:
            client = zeep.Client(
                CONFIG['BLUEBASE']['wsdl'],
                transport=zeep.transports.Transport(timeout=5)
                )
        except requests.exceptions.ConnectTimeout:
            raise ConnectionError('Le serveur SOAP 4D est injoignable')
        else:
            result = client.service.S4D(self.xml)
            response = xmltodict.parse(result)
            LOGS.logger.debug(response)
            return response

# EOF
