#!/usr/bin/env python
# encoding: utf-8


from pyftpdlib.authorizers import DummyAuthorizer
from pyftpdlib.handlers import FTPHandler
from pyftpdlib.servers import FTPServer

from ..core import CONFIG


def server(address, port, directory=CONFIG['FOLDERS']['DOWNLOAD_FOLDER']):
    authorizer = DummyAuthorizer()
    authorizer.add_anonymous(directory)
    authorizer.add_user(
        CONFIG['FTP']['username'],
        CONFIG['FTP']['password'],
        directory,
        perm="elradfmw"
        )
    handler = FTPHandler
    handler.authorizer = authorizer
    ftpd = FTPServer((address, port), handler)
    return ftpd

# EOF
