#!/usr/bin/env python
# encoding: utf-8


from to_log import Logger

import configparser
import socket


__all__ = [
    'ADDRESS',
    'APIGW',
    'CACHE',
    'CONFIG',
    'HOSTNAME',
    'LOGS',
    'SERVICE_CODE'
    ]


CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read('/etc/epg-services/epg-services.conf')

SERVICE_CODE = CONFIG['APP']['service_code']
HOSTNAME = socket.gethostname().split('.')[0]
_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
_socket.connect(("41.204.103.205", 80))
ADDRESS = _socket.getsockname()[0]
if HOSTNAME.startswith('bldv'):
    APIGW = 'bldv040v.blueline.mg'
elif HOSTNAME.startswith('blst'):
    APIGW = 'blst040v.blueline.mg'
else:
    APIGW = 'api.blueline.mg'

LOG_LEVEL = CONFIG['LOGS']['level']
LOG_FILE = CONFIG['LOGS']['filename']

LOGS = Logger('epg-services', level=LOG_LEVEL)
LOGS.set_file_handler(filename=LOG_FILE)

API_LOGS = Logger('epg-services-api', level=LOG_LEVEL)
API_LOGS.set_file_handler(filename=LOG_FILE)

BLUEFLASK_LOGS = Logger('blueflask', level=LOG_LEVEL)
BLUEFLASK_LOGS.set_file_handler(filename=LOG_FILE)

REST_CLIENT_LOGS = Logger('rest_client', level=LOG_LEVEL)
REST_CLIENT_LOGS.set_file_handler(filename=LOG_FILE)

CACHE = {
    "1": {"name": "BLUELINE TV"},
    "2": {"name": "TVM"},
    "3": {"name": "RTA"},
    "4": {"name": "RECORD TV"},
    "5": {"name": "VIVA"},
    "6": {"name": "i-BC"},
    "7": {"name": "Dream'In"},
    "8": {"name": "STREAMING"},
    "9": {"name": "Chaine du mois"},
    "10": {"name": "TV5MONDE"},
    "11": {"name": "TF1"},
    "12": {"name": "France 2"},
    "13": {"name": "France 3"},
    "15": {"name": "France 5"},
    "16": {"name": "M6"},
    "17": {"name": "Antenne Reunion"},
    "19": {"name": "W9"},
    "20": {"name": "France 24"},
    "21": {"name": "France 24 English"},
    "22": {"name": "LCI"},
    "23": {"name": "BFM TV"},
    "24": {"name": "Africanews"},
    "25": {"name": "CNN"},
    "27": {"name": "CCTV-4"},
    "28": {"name": "Voice of America"},
    "29": {"name": "Al Jazeera"},
    "30": {"name": "Gulli"},
    "31": {"name": "Cartoon Network"},
    "32": {"name": "Tiji"},
    "33": {"name": "Canal J"},
    "34": {"name": "Boing TV"},
    "35": {"name": "Boomerang"},
    "36": {"name": "TOONAMI"},
    "37": {"name": "Tivi5MONDE"},
    "38": {"name": "Mangas"},
    "39": {"name": "English Club TV"},
    "41": {"name": "AB1"},
    "43": {"name": "AB3"},
    "44": {"name": "France O"},
    "45": {"name": "E!"},
    "47": {"name": "SERIES"},
    "48": {"name": "Passions TV"},
    "49": {"name": "RTL 9"},
    "50": {"name": "MCM"},
    "51": {"name": "MCM Top"},
    "53": {"name": "RFM TV"},
    "59": {"name": "Mezzo"},
    "61": {"name": "beIN SPORTS 1"},
    "62": {"name": "beIN SPORTS 2"},
    "63": {"name": "beIN SPORTS 3"},
    "64": {"name": "Fox Sports"},
    "65": {"name": "AB Moteurs"},
    "66": {"name": "MCS"},
    "67": {"name": "SFR Sport 3"},
    "70": {"name": "Histoire"},
    "72": {"name": "Science et Vie TV"},
    "73": {"name": "Ushuaia TV"},
    "74": {"name": "Animaux TV"},
    "75": {"name": "TREK"},
    "76": {"name": "ARTE"},
    "77": {"name": "KTO"},
    "80": {"name": "TCM Cinema"},
    "82": {"name": "Crime District"},
    "83": {"name": "Action"},
    "85": {"name": "CTV"},
    "86": {"name": "CTV 2"},
    "90": {"name": "Fashion TV"},
    "109": {"name": "DORCEL TV"},
    "501": {"name": "France Info"},
    "502": {"name": "France Culture"},
    "503": {"name": "France Inter"},
    "504": {"name": "Le Moov"},
    "505": {"name": "RFI"},
    "506": {"name": "Voice of America"}
    }

# EOF
