#!/usr/bin/env python
# encoding: utf-8


from flask import Blueprint, request

from blueflask.lib.errors import forbidden, internal_error, not_allowed
from blueflask.lib.errors import not_found
from blueflask.lib.errors import unauthorized

api = Blueprint('api', __name__, url_prefix='/api/v1')
__version__ = '1.0'


@api.errorhandler(401)
def unauthorized_error(e):
    return unauthorized(request_id=request.headers.get('X-Request-ID'))


@api.errorhandler(403)
def forbidden_error(e):
    return forbidden(request_id=request.headers.get('X-Request-ID'))


@api.errorhandler(404)
def not_found_error(e):
    return not_found(request_id=request.headers.get('X-Request-ID'))


@api.errorhandler(405)
def method_not_allowed_error(e):
    return not_allowed(request_id=request.headers.get('X-Request-ID'))


@api.errorhandler(500)
def internal_server_error(e):
    msg = 'Please contact API maintainers'
    return internal_error(msg, request_id=request.headers.get('X-Request-ID'))


from . import programs  # NOQA

# EOF
