#!/usr/bin/env python
# encoding: utf-8


from setuptools import setup, find_packages


setup(
    name="epg-services",
    version='1.0.4',
    packages=find_packages(),
    author="Blueline Madagascar",
    author_email="dev@si.blueline.mg",
    license="MIT",
    classifiers=[
        "License :: MIT",
        "Natural Language :: French",
        "Operating System :: GNU/Linux",
        "Programming Language :: Python :: 3.4",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Utilities",
        ],
    install_requires=[
        'click==6.7',
        'Flask==1.0.2',
        'pyftpdlib==1.5.3',
        'wget==3.2',
        'xmltodict==0.11.0',
        'blueflask==1.1',
        'rest-client==0.2',
        'to-log==0.2',
        "records==0.5.2",
        "psycopg2==2.7.3.2"
        ],
    include_package_data=True,
    entry_points={
        'console_scripts': [
            'epg-services=epg_services.api.cli:cmd',
            ],
        }
    )
