#!/usr/bin/env python
# encoding: utf-8


from ..core import EpgSource
from .ftp import server
from . import app

import click


@click.group()
def cmd():
    pass


@cmd.command()
@click.option('--host', default='192.168.6.137')
@click.option('--port', default=2222)
def runftp(host, port):
    server(host, port).serve_forever()


@cmd.command()
@click.option('--host', default='127.0.0.1')
@click.option('--port', default=5000)
def runserver(host, port):
    app.run(host=host, port=port, debug=True)


@cmd.command()
@click.argument('epg_source')
def download(epg_source):
    """Téléchargement d'un fichier .zip contenant l'EPG"""
    try:
        source = EpgSource(epg_source)
    except KeyError:
        msg = "La source {} n'est pas configurée".format(epg_source)
        click.echo(msg)
    else:
        source.download()


@cmd.command()
@click.argument('epg_source')
def parse(epg_source):
    """Analyze du fichier XML téléchargé et création des guides prêts
    à être envoyés vers epg.blueline.mg"""
    try:
        source = EpgSource(epg_source)
    except KeyError:
        msg = "La source {} n'est pas configurée".format(epg_source)
        click.echo(msg)
    else:
        try:
            source.write_to_ftp()
        except FileNotFoundError:
            msg = "Le fichier {} n'existe pas".format(source.xmlfile)
            click.echo(msg)
