#!/usr/bin/env python
# encoding: utf-8


"""
Init values
"""

from rest_client import RestClient
from to_log import Logger

import configparser
import socket

import redis

__all__ = [
    'CONFIG',
    'HOSTNAME',
    'API_REGISTRY',
    'AIGUILLIER_URL',
    'AIGUILLIER_USERNAME',
    'LOGS',
    'DB',
    'REST_CLIENT',
    'SERVICE_CODE',
    'DAYS'
    ]

CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read('/etc/fup-services/fup-services.conf')  # CONFIG file

DAYS = [
    None,
    'Lundi',
    'Mardi',
    'Mercredi',
    'Jeudi',
    'Vendredi',
    'Samedi',
    'Dimanche'
    ]

AIGUILLIER_URL = CONFIG['AIGUILLIER']['url']
AIGUILLIER_USERNAME = CONFIG['AIGUILLIER']['username']

SERVICE_CODE = CONFIG['APP']['service_code']
HOSTNAME = socket.gethostname()
API_REGISTRY = redis.Redis(db=15)
if HOSTNAME.startswith('blpr'):
    API_REGISTRY = redis.Redis(host='api-gateway.malagasy.com', db=15)

LOG_LEVEL = CONFIG['LOGS']['level']
LOG_FILE = CONFIG['LOGS']['filename']

LOGS = Logger('fup-services')
LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

API_LOGS = Logger('fup-services-api')
API_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

BLUEFLASK_LOGS = Logger('blueflask')
BLUEFLASK_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

REST_CLIENT_LOGS = Logger('rest_client')
REST_CLIENT_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

DB = redis.Redis(
    host=CONFIG['DATABASE'].get('server', '127.0.0.1'),
    port=int(CONFIG['DATABASE'].get('port', '6379')),
    db=int(CONFIG['DATABASE'].get('db', '1')),
    password=CONFIG['DATABASE'].get('password', None)
    )

REST_CLIENT = RestClient(AIGUILLIER_URL)

# EOF
