# -*- coding: utf-8 -*-

from datetime import datetime, timedelta
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
from .consts import APIGW
from .consts import CONFIG
from .consts import REDIS_DB
from .consts import LOGS
from .customer import Customer

import calendar
import smtplib

import records
import requests
import click

__all__ = [
    'Product_GP',
    ]


class Product_GP(object):

    def __init__(self, customer_name, ident, **kwargs):
        self.ident = ident
        self.customer_name = customer_name
        self.email = kwargs.get('email')
        self.phonenumber = kwargs.get('phonenumber')
        self.notif_mail_percentage = kwargs.get('notif_mail_percentage')
        self.notif_sms_percentage = kwargs.get('notif_sms_percentage')
        self.limit = kwargs.get('limit')
        self.send_sms = kwargs.get('send_sms', 'faux')
        self.username = kwargs.get('username', 'fup-services')
        self.type_ident = kwargs.get('type_ident', 'msisdn')
        self.produit_nom = kwargs.get('produit_nom')

    def __repr__(self):
        return(
            '<Product_GP {ident}, '
            'name {name}, '
            'email {email}, '
            'phone {phone}, '
            'type_ident {type_ident}, '
            'produit_nom {produit_nom}, '
            'limit {limit}>'
            ).format(
            name=self.customer_name,
            ident=self.ident,
            email=self.email,
            phone=self.phonenumber,
            type_ident=self.type_ident,
            produit_nom=self.produit_nom,
            limit=self.limit
            )

    @staticmethod
    def all(product_type, username='fup-services'):
        click.echo(product_type)
        bluebase_url = (
            'https://{fqdn}/bluebase'
            '/v1/fup/tech_fup_list'
            ).format(
                fqdn=APIGW
                )
        response = requests.post(
            url=bluebase_url,
            auth=(username, ''),
            json={'type': product_type}
            )
        if response.status_code == 200:
            response = response.json()
            data = response['root']['data']
            infos = data['list']['produit']
            if isinstance(infos, dict):
                infos = [infos]
            result = []
            for info in infos:
                name = '{} {}'.format(
                    info['client_nom'],
                    info['client_prenom']
                    )
                ident = info['ident']
                kwargs = {
                    'limit': float(info['fup']) * 1000 * 1000 * 1000,
                    'notif_mail_percentage': float(info['notif_mail']),
                    'notif_sms_percentage': float(info.get('notif_phone', 0)),
                    'email': info.get('mail'),
                    'phonenumber': info.get('phone'),
                    'send_sms': info['send_sms'].lower(),
                    'type_ident': info['type_ident'].lower(),
                    'produit_nom': info['produit_nom'].lower()
                    }
                result.append(Product_GP(name, ident, **kwargs))
            return result

    def consumption(self, start_date, stop_date):
        """Consommation (en Bytes) sur les 30 derniers jours"""
        if not start_date:
            start_date = (datetime.now() - timedelta(30))
        if not stop_date:
            stop_date = (datetime.now() - timedelta(1))
        LOGS.logger.info(start_date)
        LOGS.logger.info(stop_date)
        url = '{eng}://{user}:{password}@{host}:{port}/{name}'.format(
            eng=CONFIG['CDRDATA']['engine'],
            user=CONFIG['CDRDATA']['username'],
            password=CONFIG['CDRDATA']['password'],
            host=CONFIG['CDRDATA']['host'],
            port=CONFIG['CDRDATA']['port'],
            name=CONFIG['CDRDATA']['name']
            )
        if self.type_ident == 'msisdn':
            with records.Database(url) as db:
                sql = (
                    'SELECT sum(totalflux) FROM '
                    'cdr.get_info_traffic_glissant('
                    ':ident, :start_date, :stop_date)'
                    )
                rows = db.query(
                    sql,
                    ident='261{}'.format(self.ident),
                    start_date=str(start_date),
                    stop_date=str(stop_date)
                    )
                for row in rows:
                    value = row[0]
                    if not value:
                        value = 0
                    else:
                        value = float(value)
                    return float(value)
        elif self.type_ident == 'mac':
            with records.Database(url) as db:
                sql = (
                    'SELECT sum(totalflux) FROM '
                    'cdr.get_info_traffic_wimax('
                    ':ident, :start_date, :stop_date)'
                    )
                rows = db.query(
                    sql,
                    ident=self.ident,
                    start_date=str(start_date),
                    stop_date=str(stop_date)
                    )
                for row in rows:
                    value = row[0]
                    if not value:
                        value = 0
                    else:
                        value = float(value)
                    return float(value)
        elif self.type_ident == 'ident':
            consos = self.details_consumption_notif(self.ident)
            value = sum([
                float(i['total_for_fup_HO'])
                for i in consos
                ])
            click.echo(value)
            return float(value)

        else:
            LOGS.logger.warn('Error identifiant non definie')
            return 0.0

    def details_consumption_notif(self, client_name):
        """Renvoie le détail de consommation des 30 derniers jours du client"""
        def str_data(conso_bytes):
            result = str(conso_bytes)
            if result == '0.0':
                return '0'
            else:
                return result
        click.echo(client_name)
        if client_name:
            client = Customer(client_name)
            cdrs = client.get_cdr_summary(daily_details=True)
            consumption = cdrs['consumption']
            details = consumption['details']
            total_notif = []
            for daily_detail in details:
                daily_cdrs_policy_wise = daily_detail['policy_wise']
                for info in daily_cdrs_policy_wise:
                    daily_total_download_for_fup_HO = info['octets_in']
                    daily_total_upload_for_fup_HO = info['octets_out']
                    daily_total_for_fup_HO = (
                        daily_total_download_for_fup_HO +
                        daily_total_upload_for_fup_HO
                        )
                    total_notif.append({
                        'total_for_fup_HO': str_data(daily_total_for_fup_HO)
                        })
            return total_notif
        else:
            return [{'total_for_fup_HO': 0.0}]

    def get_consumption_percentage(self):
        """Retourne le pourcentage de conso en fonction
        de la limite autorisée"""
        return float((self.consumption / self.limit) * 100)

    def notify(self, start_date, stop_date):
        """Notification"""
        key = 'notification:{ident}'.format(ident=self.ident)
        today = datetime.now()
        last_day_of_month = calendar.monthrange(today.year, today.month)[1]
        remaining_seconds = (last_day_of_month - today.day + 1) * 24 * 3600
        last_notification_email = REDIS_DB.hget(
            '{}:email'.format(key),
            'date'
            )
        last_notification_sms = REDIS_DB.hget(
            '{}:sms'.format(key),
            'date'
            )
        consumption = self.consumption(start_date, stop_date)
        percentage = (round(float(consumption)) / self.limit) * 100
        status = False
        click.echo('notif_mail {}'.format(self.notif_mail_percentage))
        click.echo('notif_sms {}'.format(self.notif_sms_percentage))
        if not last_notification_email and not last_notification_sms:
            # aucune notification durant ce mois
            # on fait une notification par email
            if self.notif_mail_percentage:
                if percentage >= self.notif_mail_percentage:
                    if self.send_sms == 'faux':
                        """message = (
                            "Cher client, vous vous approchez "
                            "d’une consommation mensuelle équivalente "
                            "au double de la consommation moyenne des "
                            "utilisateurs internet particuliers.\n"
                            "Arrivé à 100 Go d’usage, le débit de votre "
                            "connexion sera dégradé.\n"
                            "Nous vous invitons à consulter vos "
                            "dernières consommations sur le site "
                            "http://espace-client.blueline.mg"
                            )
                        """
                        message = (
                                "Cher Mr/Mme {name}, ayant souscrit au produit"
                                " {produit},\n\nVotre consommation internet"
                                " des 30 derniers jours atteint le double de"
                                " la consommation moyenne des clients. Afin de"
                                " protéger la qualité de service de l’ensemble"
                                " de nos clients et conformément à nos"
                                " conditions générales de ventes, nous vous"
                                " informons que nous serons peut être amenés"
                                " à diminuer le débit de votre connexion sans"
                                " toutefois la couper.\n\nPour éviter cela, "
                                " nous vous recommandons de réduire les usages"
                                " intenses tels que le téléchargements de"
                                " fichiers volumineux, l’usage des sites de"
                                " streaming video comme Youtube et Dailymotion"
                                " , etc….\n\nPour vous aider à maitriser votre"
                                " usage, nous vous invitons à vous connecter"
                                " sur votre espace client :"
                                " http://espace-client.blueline.mg pour"
                                " connaitre les informations sur votre "
                                " consommation.\n\nSi vous avez égaré votre "
                                " identifiant et votre mot de passe, merci de"
                                " contacter le service client 0 391 391 391,\n"
                                "\nBlueline vous remercie de votre"
                                " compréhension."
                                ).format(
                                name=self.customer_name,
                                produit=self.produit_nom
                                )
                        obj = (
                            "Notification de consommation élevée sur le"
                            " produit {produit}"
                            ).format(produit=self.produit_nom)
                    elif self.send_sms == 'vrai':
                        if self.type_ident == 'mac':
                            """message = (
                                "Cher client {name}, Vous vous approchez "
                                "d’une consommation mensuelle équivalente "
                                "au double de la consommation moyenne des "
                                "utilisateurs internet particuliers.\n"
                                "Arrivé à 100 Go d’usage, le débit de votre "
                                "connexion sera dégradé.\n"
                                "Nous vous invitons à consulter vos "
                                "dernières consommations sur le site "
                                "http://espace-client.blueline.mg"
                                ).format(name=self.customer_name)
                            """
                            message = (
                                "Cher Mr/Mme {name}, ayant souscrit au produit"
                                " {produit},\n\nVotre consommation internet"
                                " des 30 derniers jours atteint le double de"
                                " la consommation moyenne des clients. Afin de"
                                " protéger la qualité de service de l’ensemble"
                                " de nos clients et conformément à nos"
                                " conditions générales de ventes, nous vous"
                                " informons que nous serons peut être amenés"
                                " à diminuer le débit de votre connexion sans"
                                " toutefois la couper.\n\nPour éviter cela, "
                                " nous vous recommandons de réduire les usages"
                                " intenses tels que le téléchargements de"
                                " fichiers volumineux, l’usage des sites de"
                                " streaming video comme Youtube et Dailymotion"
                                " , etc….\n\nPour vous aider à maitriser votre"
                                " usage, nous vous invitons à vous connecter"
                                " sur votre espace client :"
                                " http://espace-client.blueline.mg pour"
                                " connaitre les informations sur votre "
                                " consommation.\n\nSi vous avez égaré votre "
                                " identifiant et votre mot de passe, merci de"
                                " contacter le service client 0 391 391 391,\n"
                                "\nBlueline vous remercie de votre"
                                " compréhension."
                                ).format(
                                name=self.customer_name,
                                produit=self.produit_nom
                                )
                            obj = (
                                "Notification de consommation élevée sur le"
                                " produit {produit}"
                                ).format(produit=self.produit_nom)
                        elif self.type_ident == 'msisdn':
                            message = (
                                "Cher client {name},\n\nVous avez "
                                "consommé {percentage}% de votre forfait.\n"
                                "Vous pouvez aller gratuitement sur le site "
                                "http://espace-client.blueline.mg pour "
                                "recharger en prépayé.\n\nBlueline vous "
                                "remercie de votre compréhension."
                                ).format(
                                percentage=self.notif_mail_percentage,
                                name=self.customer_name
                                )
                            obj = (
                                "Notification de consommation élevée sur le"
                                " produit {produit}"
                                ).format(produit=self.produit_nom)
                        elif self.type_ident == 'ident':
                            limit = round(self.limit / 1000000000)
                            message = (
                                "Cher client {name},\n\nVous avez atteint "
                                "{x} Go sur les {limit} Go "
                                "de la politique de bon usage de votre "
                                "offre Internet.\nArrivé à {limit} Go "
                                "d’usage, le débit de votre connexion "
                                "sera restreint.\nNous vous invitons à "
                                "consulter vos dernières consommations "
                                "sur votre espace client "
                                "http://espace-client.blueline.mg \n\n"
                                "Blueline vous remercie de votre "
                                "compréhension."
                                ).format(
                                x=round(
                                    self.notif_mail_percentage * limit / 100
                                    ),
                                name=self.customer_name,
                                limit=limit
                                )
                            obj = (
                                "Notification de consommation élevée sur le"
                                " produit {produit}"
                                ).format(produit=self.produit_nom)
                    # envoyer msg
                    content = MIMEText(message, 'plain', 'utf-8')
                    msg = MIMEMultipart()
                    msg['Subject'] = ('[blueline] {object}').format(object=obj)
                    msg['From'] = CONFIG['ALERT']['from_1']
                    msg['To'] = self.email
                    msg.attach(content)
                    s = smtplib.SMTP('localhost')
                    s.sendmail(
                        CONFIG['ALERT']['from_1'],
                        [self.email],
                        msg.as_string()
                        )
                    s.quit()
                    REDIS_DB.hmset(
                        '{}:email'.format(key),
                        {
                            'date': today.strftime('%d%m%Y'),
                            'consumption': consumption,
                            'limit': self.limit
                            }
                        )
                    REDIS_DB.expire(
                        '{}:email'.format(key),
                        remaining_seconds
                        )
                    status = True
            return 'email', percentage, status
        elif last_notification_email and not last_notification_sms:
            # on fait une notification par SMS
            if self.notif_sms_percentage:
                if percentage >= self.notif_sms_percentage:
                    if self.send_sms == 'vrai':
                        # envoyer SMS
                        if self.type_ident != 'ident':
                            sms = (
                                "Cher client, nous vous rappellons "
                                "que vous pouvez recharger votre connexion 4G "
                                "en prepaye en allant gratuitement sur "
                                "le site http://espace-client.blueline.mg"
                                )
                        else:
                            sms = (
                                "Cher client, vous avez atteint le "
                                "seuil de {limit} Go de la politique "
                                "de bon usage de votre offre Internet, "
                                "le debit de votre connexion est donc "
                                "restreint. Nous vous invitons a "
                                "consulter vos dernieres consommations "
                                "sur votre espace client "
                                "http://espace-client.blueline.mg"
                                ).format(
                                    limit=round(self.limit / 1000000000)
                                    )
                        requests.post(
                            url='https://{fqdn}/smsc/v1/sms'.format(
                                fqdn=APIGW
                                ),
                            auth=(self.username, ''),
                            json={
                                'message': sms,
                                'msisdn': self.phonenumber
                                }
                            )
                        REDIS_DB.hmset(
                            '{}:sms'.format(key),
                            {
                                'date': today.strftime('%d%m%Y'),
                                'consumption': consumption,
                                'limit': self.limit
                                }
                            )
                        REDIS_DB.expire(
                            '{}:sms'.format(key),
                            remaining_seconds
                            )
                        status = True
            return 'sms', percentage, status
        else:
            return None

# EOF
