#!/usr/bin/env python
# encoding: utf-8


from setuptools import setup, find_packages


setup(
    name="fup-services",
    author="Blueline Madagascar",
    author_email="dev@si.blueline.mg",
    version="2.5.0",
    packages=find_packages(),
    description="Application de Fair Usage Policy",
    license='MIT',
    include_package_data=True,
    install_requires=[
        'click==6.7',
        'jinja2==2.10',
        'pytz==2018.4',
        'redis==2.10.6',
        'systemd-python==234',
        'tablib==0.12.1',
        'tzlocal==1.4',
        'blueflask==1.1',
        'records==0.5.2',
        'psycopg2==2.7.3.2',
        'to-log==0.2',
        'rest-client==0.2'
        ],
    entry_points={
        'console_scripts': ['fup-services=fup_services.api.cli:cmd'],
        }
)
