#!/usr/bin/env python
# encoding: utf-8

from .core import Client
from .consts import LOGS, SERVICE_CODE, CONFIG

import threading

import json
import pika


def process(telnet_client, url_smsc, queue):
    """Traitement des files d'attentes"""

    def callback(ch, method, properties, body):
        try:
            document = json.loads(body.decode('utf-8'))
        except Exception as exc:
            LOGS.logger.error(exc)
            ch.basic_ack(delivery_tag=method.delivery_tag)
        else:
            condition = (
                'isdn' not in document['json'] or
                'imsi' not in document['json']
                )
            if condition:
                ch.basic_ack(delivery_tag=method.delivery_tag)
            else:
                ch.basic_ack(delivery_tag=method.delivery_tag)
                imsi = document['json']['imsi']
                isdn = document['json']['isdn']
                try:
                    telnet_client.add_subscriber(imsi, isdn)
                except Exception as exc:
                    LOGS.logger.error(exc)
                    ch.basic_publish(
                        exchange='sendcmd',
                        routing_key=queue,
                        body=json.dumps(document),
                        properties=pika.BasicProperties(delivery_mode=2)
                        )
                else:
                    code = telnet_client.response['code']
                    message = telnet_client.response['message']
                    return_code = '{service_code}-{code}'.format(
                        service_code=SERVICE_CODE,
                        code=code
                        )
                    if code:
                        if code == 3002:
                            # envoyer un SMS pour dire qu'en fait c'est ok
                            LOGS.logger.info(message)
                        else:
                            msg = {
                                'status': 500,
                                'error': 'erreur interne',
                                'code': return_code,
                                'message': message
                                }
                            LOGS.logger.error(msg)
                    else:
                        telnet_client.update_gprs_profile(imsi, True)
                        code = telnet_client.response['code']
                        message = telnet_client.response['message']
                        return_code = '{service_code}-{code}'.format(
                            service_code=SERVICE_CODE,
                            code=code
                            )
                        if code:
                            msg = {
                                'status': 500,
                                'error': 'erreur interne',
                                'code': return_code,
                                'message': message
                                }
                            LOGS.logger.error(msg)
                        else:
                            LOGS.logger.info(message)
                            # envoyer un SMS pour dire c'est OK

    connection = pika.BlockingConnection(
        pika.ConnectionParameters(
            host='localhost',
            virtual_host='/hlr'
            )
        )
    channel = connection.channel()
    channel.basic_qos(prefetch_count=1)
    channel.basic_consume(callback, queue=queue)
    channel.start_consuming()


class Worker(threading.Thread):

    def __init__(self, name, queue):
        threading.Thread.__init__(self)
        self.name = name
        self.queue = queue
        self.telnet_client = Client()
        self.url_smsc = CONFIG['SERVICES']['smsc']

    def run(self):
        process(self.telnet_client, self.url_smsc, self.queue)


# EOF
