#!/usr/bin/env python
# encoding: utf-8

"""
Application permettant d'explorer et modifier l'annuaire LDAP de blueline.
Propose aussi une API REST.
"""

from .consts import *  # NOQA
from .core import *  # NOQA
from .objects import *  # NOQA

import pika

connection = pika.BlockingConnection(
    pika.ConnectionParameters(
        host='localhost',
        virtual_host='/ldap'
        )
    )

channel = connection.channel()

channel.exchange_declare(exchange='async_requests', exchange_type='topic')

channel.queue_declare(queue='GET.ldap', durable=True)
channel.queue_bind(exchange='async_requests', queue='GET.ldap')

channel.queue_declare(queue='POST.ldap', durable=True)
channel.queue_bind(exchange='async_requests', queue='POST.ldap')

channel.queue_declare(queue='PUT.ldap', durable=True)
channel.queue_bind(exchange='async_requests', queue='PUT.ldap')

channel.queue_declare(queue='DELETE.ldap', durable=True)
channel.queue_bind(exchange='async_requests', queue='DELETE.ldap')

connection.close()

# EOF
