#!/usr/bin/env python
# encoding: utf-8


from flask import jsonify

from blueflask.lib.errors import not_found
from blueflask.lib.infos import no_content

from ...objects import AppGroup
from ...consts import SERVICE_CODE
from . import api


@api.route('/apps/permissions', methods=['GET'])
def get_apps_permissions_groups():
    app_groups = AppGroup.all()
    if not app_groups:
        return no_content(service_code=SERVICE_CODE)
    result = {
        'length': len(app_groups),
        'permissions': [
            {
                'app': group.app.name,
                'name': group.name
                }
            for group in app_groups
            ]
        }
    return jsonify(result)


@api.route('/apps/permissions/<string:name>', methods=['GET'])
def get_permission_group_members(name):
    try:
        app_group = AppGroup(name)
    except IndexError:
        return not_found(service_code=SERVICE_CODE)
    else:
        members = app_group.members
        result = {
            'name': app_group.name,
            'app': app_group.name,
            'members': [
                {
                    'name': member.name,
                    'uid': member.uid
                    }
                for member in members
                ]
            }
        return jsonify(result)

# EOF
