#!/usr/bin/env python
# encoding: utf-8


from flask import Blueprint

from blueflask.lib.errors import internal_error, not_allowed, not_found
from ...consts import SERVICE_CODE

api = Blueprint('api', __name__, url_prefix='/api/v2')
__version__ = '2.0'


@api.errorhandler(404)
def not_found_error(e):
    return not_found(
        'item not found',
        service_code=SERVICE_CODE
        )


@api.errorhandler(500)
def internal_server_error(e):
    msg = 'Please contact API maintainers'
    return internal_error(
        msg,
        service_code=SERVICE_CODE
        )


@api.errorhandler(405)
def method_not_allowed_error(e):
    return not_allowed(service_code=SERVICE_CODE)


from . import apps, auth, departments, positions, users  # NOQA

# EOF
