import requests
import xmltodict
from zeep import Client
# from .notification import Notification
from .consts import (
    LOGS,
    APIGW,
    PAYLOAD,
    WSDL
    )


def get_token():
    new_token = requests.post(
        'https://api.blueline.mg/dev/auth/request-token',
        auth=('zato', 'qlnwFMKXqAe2soL7eYsx')
        )
    return new_token.json()['token']


def auth_ussd(data):
    token = get_token()
    response = requests.post(
        'https://api.blueline.mg/dev/bluebase/v1/izytv/auth_ussd',
        auth=(token, ''),
        json=data
        )
    response = response.json()
    return response


def izytv_auth_ussd(login, caller_num):
    LOGS.logger.info("Izytv auth")
    data = {
        'session': '',
        "operator": "bip",
        "caller_num": caller_num,
        "type_auth": "izytv_login",
        "login_auth": login,
        "service_type": "izytv"
        }
    payload = PAYLOAD
    payload['root']['header']['param1'] = 'auth_ussd'
    payload['root']['data'] = data
    LOGS.logger.info(payload)
    try:
        LOGS.logger.info("Let's go")
        bluebase_client = Client(WSDL)
        response = bluebase_client.service.S4D(xmltodict.unparse(payload))
        response = xmltodict.parse(response)
        if response['root']['header'].get("errorNum") == '0':
            if response['root']['data'].get('error'):
                response = {
                    "code": "044-05-{}".format(
                        response['root']['data']['error_num']
                        ),
                    "message": response['root']['data'],
                    "status": int(response['root']['data']['error_num']),
                    }
                LOGS.logger.info(response)
            else:
                response = {
                    "code": "044-05-200",
                    "message": response['root']['data'],
                    "status": 200,
                    }
                LOGS.logger.info(response)
        elif response['root']['header'].get("errorNum") != '0':
            response = {
                "code": "044-05-{}".format(
                    response['root']['header']["errorNum"]
                    ),
                "message": response['root']['header']['errorTx'],
                "status": int(response['root']['header']["errorNum"]),
                }
            LOGS.logger.info(response)
    except Exception:
        response = {
                "code": "044-05-404",
                "message": "Serveur 4D introuvable",
                "status": 404,
                }
        LOGS.logger.info("Faild :( !!!")
        LOGS.logger.info(response)
    return response


def izytv_get_subscription_infos(data):
    LOGS.logger.info("Izytv get offer 4D")
    payload = PAYLOAD
    payload['root']['header']['param1'] = 'ussd_get_infos'
    payload['root']['data'] = data
    LOGS.logger.info(payload)
    try:
        LOGS.logger.info("Let's go")
        bluebase_client = Client(WSDL)
        response = bluebase_client.service.S4D(xmltodict.unparse(payload))
        response = xmltodict.parse(response)
        LOGS.logger.info(response)

        # bouquet['name'] = bouquet.pop('intitule')
        # bouquet['value'] = bouquet.pop('date_fin')
        if response['root']['header'].get("errorNum") == '0':
            if response['root']['data'].get('error'):
                if response['root']['data']['error_num'] == '-1':
                    response = {
                        "code": "044-05-{}".format(
                            4016
                            ),
                        "message": response['root']['data'],
                        "status": 4016,
                        }
                else:
                    response = {
                        "code": "044-05-{}".format(
                            response['root']['data']['error_num']
                            ),
                        "message": response['root']['data'],
                        "status": int(response['root']['data']['error_num']),
                        }
                LOGS.logger.info(response)
            else:
                bouquets = response['root']['data'].get('bouquet')
                if not isinstance(bouquets, list):
                        bouquets = [bouquets]
                bouquets = [
                        {
                            "name": bouquet["intitule"],
                            "value": bouquet["date_fin"]
                            }
                        for bouquet in bouquets
                    ]
                response = {
                    "code": "044-05-200",
                    "message": bouquets,
                    "status": 200,
                    }
                LOGS.logger.info(response)
        elif response['root']['header'].get("errorNum") != '0':
            response = {
                "code": "044-05-{}".format(
                    response['root']['header']["errorNum"]
                    ),
                "message": response['root']['header']['errorTx'],
                "status": int(response['root']['header']["errorNum"]),
                }
            LOGS.logger.info(response)
    except Exception:
        response = {
            "code": "044-05-404",
            "message": "Serveur 4D introuvable",
            "status": 404,
            }
        LOGS.logger.info("Faild :( !!!")
        LOGS.logger.info(response)

    return response


def izytv_get_offer(data):
    LOGS.logger.info("Izytv get offer 4D")
    payload = PAYLOAD
    payload['root']['header']['param1'] = 'ussd_get_recharge'
    payload['root']['data'] = data
    LOGS.logger.info(payload)
    try:
        LOGS.logger.info("Let's go")
        bluebase_client = Client(WSDL)
        response = bluebase_client.service.S4D(xmltodict.unparse(payload))
        response = xmltodict.parse(response)
        if response['root']['header'].get("errorNum") == '0':
            if response['root']['data'].get('error'):
                response = {
                    "code": "044-05-{}".format(
                        response['root']['data']['error_num']
                        ),
                    "message": response['root']['data'],
                    "status": int(response['root']['data']['error_num']),
                    }
                LOGS.logger.info(response)
            else:
                response = {
                    "code": "044-05-200",
                    "message": response['root']['data']['offre'],
                    "status": 200,
                    }
                LOGS.logger.info(response)
        elif response['root']['header'].get("errorNum") != '0':
            response = {
                "code": "044-05-{}".format(
                    response['root']['header']["errorNum"]
                    ),
                "message": response['root']['header']['errorTx'],
                "status": int(response['root']['header']["errorNum"]),
                }
            LOGS.logger.info(response)
    except Exception:
        response = {
            "code": "044-05-404",
            "message": "Serveur 4D introuvable",
            "status": 404,
            }
        LOGS.logger.info("Faild :( !!!")
        LOGS.logger.info(response)

    return response


def izytv_buy_recharge(data):
    LOGS.logger.info("Izytv buy offer")
    payload = PAYLOAD
    payload['root']['header']['param1'] = 'ussd_buy_recharge'
    payload['root']['data'] = data
    LOGS.logger.info(payload)
    try:
        LOGS.logger.info("Let's go")
        bluebase_client = Client(WSDL)
        response = bluebase_client.service.S4D(xmltodict.unparse(payload))
        response = xmltodict.parse(response)
        if response['root']['header'].get("errorNum") == '0':
            if response['root']['data'].get('error'):
                response = {
                    "code": "044-05-{}".format(
                        response['root']['data']['error_num']
                        ),
                    "message": response['root']['data'],
                    "status": int(response['root']['data']['error_num']),
                    }
                LOGS.logger.info(response)
            else:
                response = {
                    "code": "044-05-200",
                    "message": "Recharge successfully :) ",
                    "status": 200,
                    }
                LOGS.logger.info(response)
        elif response['root']['header'].get("errorNum") != '0':
            response = {
                "code": "044-05-{}".format(
                    response['root']['header']["errorNum"]
                    ),
                "message": response['root']['header']['errorTx'],
                "status": int(response['root']['header']["errorNum"]),
                }
            LOGS.logger.info(response)
    except Exception:
        response = {
            "code": "044-05-404",
            "message": "Serveur 4D introuvable",
            "status": 404,
            }
        LOGS.logger.info("Faild :( !!!")
        LOGS.logger.info(response)

    return response


def customer_register(data):
    LOGS.logger.info(data)
    bluebase_url = (
        'https://{fqdn}/bluebase'
        '/v1/izytv/izytv_inscription'
        ).format(
            fqdn=APIGW
            )
    response = requests.post(
        url=bluebase_url,
        auth=('izytv', ''),
        json=data
        )
    response = response = response.json()
    response = {
        "code": "044-05-200",
        "message": response,
        "status": 200,
    }
    return response


def customer_update(data):
    LOGS.logger.info(data)
    bluebase_url = (
        'https://{fqdn}/bluebase'
        '/v1/izytv/izyTV_modif'
        ).format(
            fqdn=APIGW
            )
    response = requests.post(
        url=bluebase_url,
        auth=('izytv', ''),
        json=data
        )
    response = response = response.json()
    response = {
        "code": "044-05-200",
        "message": response,
        "status": 200,
    }
    return response


def customer_notif(data):
    LOGS.logger.info(data)
    bluebase_url = (
        'https://{fqdn}/bluebase'
        '/v1/izytv/izyTV_pass_reset'
        ).format(
            fqdn=APIGW
            )
    response = requests.post(
        url=bluebase_url,
        auth=('izytv', ''),
        json=data
        )
    response = response.json()
    response = {
        "code": "044-05-200",
        "message": response,
        "status": 200,
    }
    return response
