import requests
from .consts import (
    LDAP_LOGIN,
    LDAP_PSW,
    OCS_URI,
    TOKEN_URL,
    SMSC_URI,
    LOGS
    )


def get_token():
    new_token = requests.post(
        TOKEN_URL,
        auth=(LDAP_LOGIN, LDAP_PSW)
        )
    return new_token.json()['token']


def send_sms(data):
    token = get_token()
    result = requests.post(
            "{smsc_uri}/sms".format(smsc_uri=SMSC_URI),
            auth=(token, ""),
            json=data
        )
    if result.status_code != 200:
        LOGS.logger.critical("echec envoi sms à {}".format(data["msisdn"]))
    else:
        LOGS.logger.critical("Envoi sms OK, numero {}".format(data["msisdn"]))


def get_balance(phonenumber, auth):
    response = requests.get(
        '{ocs_uri}/subscribers/{phonenumber}/balances'.format(
            ocs_uri=OCS_URI,
            phonenumber=phonenumber
            ),
        auth=(auth, ''),
        json={"account_type": "2000"}
        )
    LOGS.logger.info(response)
    if response.status_code == 200:
        balance = response.json()['message']['balance']
        LOGS.logger.info(response)
        response = {
                "code": "044-05-{}".format(response.status_code),
                "info": "Successful",
                "message": {"balance": balance},
                "status": response.status_code
            }
    else:
        LOGS.logger.info("Echec de récuperation du solde")
        response = {
                "code": "044-05-{}".format(response.status_code),
                "info": "Erreur",
                "message": """La récuperation de """
                """du solde à échouer""",
                "status": response.status_code
            }
    return response


def update_balance(phonenumber, amount, auth, operation):
    if operation == "moins":
        due = -1 * int(amount)  # params["amount"]
        infos = 'Retrait de %s sur le solde du client' % (str(amount))
    else:
        due = int(amount)
        infos = 'Rollback de %s sur le solde du client' % (str(amount))
    account_new = requests.put(
        "{uri_ocs}/subscribers/{num}/balances".format(
            num=phonenumber,
            uri_ocs=OCS_URI
            ),
        auth=(auth, ""),
        json={
            "amount": due,
            "infos": 'Izytv',
            "operation_type": "2",
            "account_type": 2000
        },
    )
    LOGS.logger.info(account_new)
    if account_new.status_code == 200:
        response = {
            "code": "044-05-{}".format(
                account_new.status_code
                ),
            "info": infos,
            "message": "Operation successful",
            "status": account_new.status_code,
        }
        LOGS.logger.info(response)
    else:
        response = {
            "code": "044-05-{}".format(
                account_new.status_code
                ),
            "info": "Changement du solde dans ocs",
            "message": "L'opération a échoué",
            "status": account_new.status_code,
        }
        LOGS.logger.info(response)
    return response


def get_language(phonenumber, auth):
    response = requests.get(
        "{ocs_uri}/subscribers/{phonenumber}".format(
            ocs_uri=OCS_URI,
            phonenumber=phonenumber
            ),
        auth=(auth, ""),
        json={"key": "language_code"},
    )
    response = response.json()
    LOGS.logger.info(response)
    return response["message"]["language_code"]
