#!/usr/bin/env python
# encoding: utf-8


import configparser
import socket

import pika
import redis

import to_log

__all__ = [
    'CONFIG',
    'LOGS',
    'HOSTNAME',
    'API_REGISTRY',
    'OCS_WSDL_ROOT',
    'REDIS_DB',
    'SERVICE_CODE'
    ]

CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read('/etc/ocs-services/ocs-services.conf')

SERVICE_CODE = CONFIG['APP']['service_code']
HOSTNAME = socket.gethostname().split('.')[0]
API_REGISTRY = redis.Redis(db=15)
if HOSTNAME.startswith('blpr'):
    API_REGISTRY = redis.Redis(host='api.blueline.mg', db=15)

LOG_FILE = CONFIG['LOGS']['filename']
LOG_LEVEL = CONFIG['LOGS']['level']

LOGS = to_log.Logger('ocs-services')
LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

API_LOGS = to_log.Logger('ocs-services-api')
API_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

BLUEFLASK_LOGS = to_log.Logger('blueflask')
BLUEFLASK_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

REST_CLIENT_LOGS = to_log.Logger('rest_client')
REST_CLIENT_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

OCS_WSDL_ROOT = CONFIG['SOAP']['url']

REDIS_DB = redis.Redis(
    host=CONFIG['REDIS_DB'].get('host', 'localhost'),
    port=int(CONFIG['REDIS_DB'].get('port', '6379')),
    db=int(CONFIG['REDIS_DB'].get('db', '2')),
    password=CONFIG['REDIS_DB'].get('password', None)
    )

connection = pika.BlockingConnection(
    pika.ConnectionParameters(
        host='localhost',
        virtual_host='/ocs'
        )
    )

channel = connection.channel()

channel.exchange_declare(exchange='async_requests', exchange_type='topic')

channel.queue_declare(queue='GET.ocs', durable=True)
channel.queue_bind(exchange='async_requests', queue='GET.ocs')

channel.queue_declare(queue='POST.ocs', durable=True)
channel.queue_bind(exchange='async_requests', queue='POST.ocs')

channel.queue_declare(queue='PUT.ocs', durable=True)
channel.queue_bind(exchange='async_requests', queue='PUT.ocs')

channel.queue_declare(queue='DELETE.ocs', durable=True)
channel.queue_bind(exchange='async_requests', queue='DELETE.ocs')

connection.close()

# EOF
