#!/usr/bin/env python
# encoding: utf-8

from flask import Blueprint, g, request

from blueflask.lib.errors import not_allowed, not_found
from blueflask.lib.errors import internal_error, unauthorized

__version__ = '1.0'

api = Blueprint('api', __name__, url_prefix='/api/v1')


def get_operator(data=None):
    if data and data.get('operator'):
        operator_id = data.get('operator')
        del data['operator']
        user = operator_id
    else:
        user = min(g.user, key=lambda x: len(x))
        if len(user) > 20:
            user = user[:20]
    return user, data


@api.errorhandler(401)
def unauthorized_error(e):
    return unauthorized(request_id=request.headers.get('X-Request-ID'))


@api.errorhandler(404)
def not_found_error(e):
    return not_found(request_id=request.headers.get('X-Request-ID'))


@api.errorhandler(405)
def method_not_allowed_error(e):
    return not_allowed(request_id=request.headers.get('X-Request-ID'))


@api.errorhandler(500)
def internal_server_error(e):
    return internal_error(
        request_id=request.headers.get('X-Request-ID')
        )


from . import async  # NOQA
from . import auth  # NOQA
from . import subscribers  # NOQA
from . import services  # NOQA

# EOF
