# -*- coding: utf-8 -*-

import configparser
import socket

import redis

import to_log

__all__ = [
    "ADDRESS",
    "APIGW",
    "CONFIG",
    "GUNICORN_PORT",
    "HOSTNAME",
    "LOGS",
    "OCS_WSDL_ROOT",
    "REDIS_DB",
    "SERVICE_CODE",
]


CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read("/etc/ocs-services/ocs-services.conf")

SERVICE_CODE = CONFIG["APP"]["service_code"]
GUNICORN_PORT = int(SERVICE_CODE[1:].replace("-", ""))
HOSTNAME = socket.gethostname().split(".")[0]
_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
_socket.connect(("41.204.103.205", 80))
ADDRESS = _socket.getsockname()[0]
REDIS_DB = redis.Redis()

if HOSTNAME.startswith("bldv"):
    APIGW = "bldv040v.blueline.mg"
elif HOSTNAME.startswith("blst"):
    APIGW = "blst040v.blueline.mg"
else:
    APIGW = "api.blueline.mg"
    REDIS_DB = redis.Redis(db=int(SERVICE_CODE.split("-")[1]))

LOG_FILE = CONFIG["LOGS"]["filename"]
LOG_LEVEL = CONFIG["LOGS"]["level"]

LOGS = to_log.Logger("ocs-services")
LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

API_LOGS = to_log.Logger("ocs-services-api")
API_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

BLUEFLASK_LOGS = to_log.Logger("blueflask")
BLUEFLASK_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

REST_CLIENT_LOGS = to_log.Logger("rest_client")
REST_CLIENT_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

OCS_WSDL_ROOT = CONFIG["SOAP"]["url"]

# EOF
