#!/usr/bin/env pyhon
# encoding: utf-8

# from blueflask.lib.decorators import auth as ldap
from blueflask.lib.errors import bad_request
from flask import jsonify, request
from ...picking import Locations, PickingRequest
from ...consts import SERVICE_CODE, ODOO_URI, LOGIN_ODOO, API_LOGS
from . import api
import requests


def get_session():
    pass


@api.route('/stocks/locations/create', methods=['POST'])
def create_locations():
    """
    Création d'un emplacement.
    Ce endpoint permet de créer un emplacement de stock.
    ---
    tags:
      - locations
    components:
      securitySchemes:
        basicAuth:
          type: http
          scheme: basic
    security:
      - basicAuth: []
    definitions:
      - schema:
          id: Error message
          properties:
            status:
              type: string
              description: code d'erreur HTTP
            code:
              type: number
              description: code d'erreur d'application
            error:
              type: string
              description: message court décrivant le type d'erreur
            message:
              type: string
              description: détails sur l'erreur rencontrée
      - schema:
          id: Info message
          properties:
            status:
              type: string
              description: code d'info HTTP
            code:
              type: number
              description: code d'info d'application
            info:
              type: string
              description: message court décrivant le type d'info
            message:
              type: string
              description: détails
    responses:
      202:
        description: La création de l'emplacement est passé
        $ref: "#/definitions/Info message"
      400:
        description: La requête est incorecte
        $ref: "#/definitions/Error message"
      401:
        description: Authentification incorects
        $ref: "#/definitions/Error message"
      500:
        description: L'API a recontré une erreur
        $ref: "#/definitions/Error message"
    """
    data = request.get_json()
    name = data['name']
    usage = data['usage']
    location_id = data['location_id']
    response = Locations.create(name, usage, location_id)
    if not response:
        return bad_request(
            'Provide a valid JSON document',
            service_code=SERVICE_CODE
            )
    else:
        result = {
            'request_id': response['content']['request_id'],
            'location_id': data['location_id']
            }
        return jsonify(result)


@api.route('/stocks/locations', methods=['GET'])
def locations_list():
    """
    Lister les emplacement.
    Ce endpoint permet de d'avoir la liste des emplacements.
    ---
    tags:
      - locations
    components:
      securitySchemes:
        basicAuth:
          type: http
          scheme: basic
    security:
      - basicAuth: []
    definitions:
      - schema:
          id: Error message
          properties:
            status:
              type: string
              description: code d'erreur HTTP
            code:
              type: number
              description: code d'erreur d'application
            error:
              type: string
              description: message court décrivant le type d'erreur
            message:
              type: string
              description: détails sur l'erreur rencontrée
      - schema:
          id: Info message
          properties:
            status:
              type: string
              description: code d'info HTTP
            code:
              type: number
              description: code d'info d'application
            info:
              type: string
              description: message court décrivant le type d'info
            message:
              type: string
              description: détails
    responses:
      202:
        description: La création de l'emplacement est passé
        $ref: "#/definitions/Info message"
      400:
        description: La requête est incorecte
        $ref: "#/definitions/Error message"
      401:
        description: Authentification incorects
        $ref: "#/definitions/Error message"
      500:
        description: L'API a recontré une erreur
        $ref: "#/definitions/Error message"
    """
    session = requests.Session()
    session.post(
         '{}/web/session/authenticate'.format(ODOO_URI),
         json=LOGIN_ODOO
         )
    locations = session.get(
        '{uri}/api/v1/stocks/locations'.format(
            uri=ODOO_URI
            )
        )
    locations = locations.json()
    response = {
        'locations': [
            {
                'location_id': location['id'],
                'name': location['name'],
                'usage': location['usage']
                }
            for location in locations
            ]
        }
    return jsonify(response)


@api.route('/stocks/locations/<string:location_id>', methods=['GET'])
def stock_by_location(location_id):
    """
    Voir l'état du stock d'un emplacement.
    Ce endpoint permet de savoir l'état du stock d'un emplacement précis.
    ---
    tags:
      - locations
    components:
      securitySchemes:
        basicAuth:
          type: http
          scheme: basic
    security:
      - basicAuth: []
    definitions:
      - schema:
          id: Error message
          properties:
            status:
              type: string
              description: code d'erreur HTTP
            code:
              type: number
              description: code d'erreur d'application
            error:
              type: string
              description: message court décrivant le type d'erreur
            message:
              type: string
              description: détails sur l'erreur rencontrée
      - schema:
          id: Info message
          properties:
            status:
              type: string
              description: code d'info HTTP
            code:
              type: number
              description: code d'info d'application
            info:
              type: string
              description: message court décrivant le type d'info
            message:
              type: string
              description: détails
    responses:
      202:
        description: La création de l'emplacement est passé
        $ref: "#/definitions/Info message"
      400:
        description: La requête est incorecte
        $ref: "#/definitions/Error message"
      401:
        description: Authentification incorects
        $ref: "#/definitions/Error message"
      500:
        description: L'API a recontré une erreur
        $ref: "#/definitions/Error message"
    """
    session = requests.Session()
    session.post(
         '{}/web/session/authenticate'.format(ODOO_URI),
         json=LOGIN_ODOO
         )
    products = session.get(
        '{uri}/api/v1/stocks/picking/stock_by_location/{id}'.format(
            uri=ODOO_URI,
            id=location_id
            )
        )
    products = products.json()
    API_LOGS.logger.info(products)
    if products[0].get('resultat'):
        response = {
            'products': []
            }
    else:
        response = {
            'products': [
                {
                    'product_id':
                        {
                            'id': product['product_id']['id'],
                            'name': product['product_id']['name']
                        },
                    'quantity': product['quantity']
                    }
                for product in products
                ]
            }
    return jsonify(response)


@api.route('/stocks/picking/requests', methods=['POST'])
def picking_requests():
    """
    Création d'une demande de sortie de stock.
    Ce endpoint permet de faire une demande de sortie de stock.
    ---
    tags:
      - picking
    components:
      securitySchemes:
        basicAuth:
          type: http
          scheme: basic
    security:
      - basicAuth: []
    definitions:
      - schema:
          id: Error message
          properties:
            status:
              type: string
              description: code d'erreur HTTP
            code:
              type: number
              description: code d'erreur d'application
            error:
              type: string
              description: message court décrivant le type d'erreur
            message:
              type: string
              description: détails sur l'erreur rencontrée
      - schema:
          id: Info message
          properties:
            status:
              type: string
              description: code d'info HTTP
            code:
              type: number
              description: code d'info d'application
            info:
              type: string
              description: message court décrivant le type d'info
            message:
              type: string
              description: détails
    responses:
      202:
        description: La création de l'emplacement est passé
        $ref: "#/definitions/Info message"
      400:
        description: La requête est incorecte
        $ref: "#/definitions/Error message"
      401:
        description: Authentification incorects
        $ref: "#/definitions/Error message"
      500:
        description: L'API a recontré une erreur
        $ref: "#/definitions/Error message"
    """
    data = request.get_json()
    response = PickingRequest.create(data)
    return jsonify(response['content'])


@api.route('/stocks/picking/status/<string:request_id>', methods=['GET'])
def picking_status(request_id):
    """
    Savoir l'état de la demande.
    Ce endpoint permet de savoir l'état d'une demande de sortie de stock.
    ---
    tags:
      - picking
    components:
      securitySchemes:
        basicAuth:
          type: http
          scheme: basic
    security:
      - basicAuth: []
    definitions:
      - schema:
          id: Error message
          properties:
            status:
              type: string
              description: code d'erreur HTTP
            code:
              type: number
              description: code d'erreur d'application
            error:
              type: string
              description: message court décrivant le type d'erreur
            message:
              type: string
              description: détails sur l'erreur rencontrée
      - schema:
          id: Info message
          properties:
            status:
              type: string
              description: code d'info HTTP
            code:
              type: number
              description: code d'info d'application
            info:
              type: string
              description: message court décrivant le type d'info
            message:
              type: string
              description: détails
    responses:
      202:
        description: La création de l'emplacement est passé
        $ref: "#/definitions/Info message"
      400:
        description: La requête est incorecte
        $ref: "#/definitions/Error message"
      401:
        description: Authentification incorects
        $ref: "#/definitions/Error message"
      500:
        description: L'API a recontré une erreur
        $ref: "#/definitions/Error message"
    """
    picking = PickingRequest(request_id)
    response = picking.status()
    # response = picking.status()['content']
    API_LOGS.logger.info(response)

    return jsonify(response)


@api.route('/stocks/picking/details/<string:request_id>', methods=['GET'])
def picking_details(request_id):
    """
    Savoir l'état de la demande.
    Ce endpoint permet de savoir l'état d'une demande de sortie de stock.
    ---
    tags:
      - picking
    components:
      securitySchemes:
        basicAuth:
          type: http
          scheme: basic
    security:
      - basicAuth: []
    definitions:
      - schema:
          id: Error message
          properties:
            status:
              type: string
              description: code d'erreur HTTP
            code:
              type: number
              description: code d'erreur d'application
            error:
              type: string
              description: message court décrivant le type d'erreur
            message:
              type: string
              description: détails sur l'erreur rencontrée
      - schema:
          id: Info message
          properties:
            status:
              type: string
              description: code d'info HTTP
            code:
              type: number
              description: code d'info d'application
            info:
              type: string
              description: message court décrivant le type d'info
            message:
              type: string
              description: détails
    responses:
      202:
        description: La création de l'emplacement est passé
        $ref: "#/definitions/Info message"
      400:
        description: La requête est incorecte
        $ref: "#/definitions/Error message"
      401:
        description: Authentification incorects
        $ref: "#/definitions/Error message"
      500:
        description: L'API a recontré une erreur
        $ref: "#/definitions/Error message"
    """
    picking = PickingRequest(request_id)
    response = picking.details()

    if response["status"] != 200:
        status = response["status"]
        data =  {}
    else:
        status = 200
        data =  response["content"]

    response = {
        "status": status,
        "details": data
        }

    return jsonify(response)


@api.route('/stocks/picking/validate/<string:request_id>', methods=['POST'])
def validate_picking(request_id):
    """
    Mettre à jour la demande.
    Ce endpoint permet de faire la mis à jour d'une demande de sortie de stock.
    ---
    tags:
      - picking
    components:
      securitySchemes:
        basicAuth:
          type: http
          scheme: basic
    security:
      - basicAuth: []
    definitions:
      - schema:
          id: Error message
          properties:
            status:
              type: string
              description: code d'erreur HTTP
            code:
              type: number
              description: code d'erreur d'application
            error:
              type: string
              description: message court décrivant le type d'erreur
            message:
              type: string
              description: détails sur l'erreur rencontrée
      - schema:
          id: Info message
          properties:
            status:
              type: string
              description: code d'info HTTP
            code:
              type: number
              description: code d'info d'application
            info:
              type: string
              description: message court décrivant le type d'info
            message:
              type: string
              description: détails
    responses:
      202:
        description: La création de l'emplacement est passé
        $ref: "#/definitions/Info message"
      400:
        description: La requête est incorecte
        $ref: "#/definitions/Error message"
      401:
        description: Authentification incorects
        $ref: "#/definitions/Error message"
      500:
        description: L'API a recontré une erreur
        $ref: "#/definitions/Error message"
    """
    data = request.get_json()
    picking = PickingRequest(request_id)
    response = picking.update(data)
    return jsonify(response['content'])


@api.route('/stocks/picking/return', methods=['POST'])
def return_picking():
    """
    Création d'une retour de stock.
    Ce endpoint permet de créer une retour de stock.
    ---
    tags:
      - picking
    components:
      securitySchemes:
        basicAuth:
          type: http
          scheme: basic
    security:
      - basicAuth: []
    definitions:
      - schema:
          id: Error message
          properties:
            status:
              type: string
              description: code d'erreur HTTP
            code:
              type: number
              description: code d'erreur d'application
            error:
              type: string
              description: message court décrivant le type d'erreur
            message:
              type: string
              description: détails sur l'erreur rencontrée
      - schema:
          id: Info message
          properties:
            status:
              type: string
              description: code d'info HTTP
            code:
              type: number
              description: code d'info d'application
            info:
              type: string
              description: message court décrivant le type d'info
            message:
              type: string
              description: détails
    responses:
      202:
        description: La création de l'emplacement est passé
        $ref: "#/definitions/Info message"
      400:
        description: La requête est incorecte
        $ref: "#/definitions/Error message"
      401:
        description: Authentification incorects
        $ref: "#/definitions/Error message"
      500:
        description: L'API a recontré une erreur
        $ref: "#/definitions/Error message"
    """
    data = request.get_json()
    response = PickingRequest.return_picking(data)
    return jsonify(response['content'])


@api.route('/stocks/moves', methods=['GET'])
def entre_deux_date():
    """
    Entre deux date
    """
    picking = PickingRequest()
    data = request.get_json()
    response = picking.entre_deux_date(
        data["start_date"],
        data["end_date"]
        )
    return jsonify(response)


@api.route('/stocks/incoming/<string:location_id>', methods=['GET'])
def incoming(location_id):
    picking = PickingRequest()
    response = picking.incoming(int(location_id))
    result = {'incoming': response}
    response = {
        "status": 200,
        "message": result
        }
    return jsonify(response)


@api.route(
    '/stocks/product_lot/<string:location_id>',
    methods=['GET']
    )
def product_lot(location_id):
    data = request.get_json()
    picking = PickingRequest()
    response = picking.product_lot(
        int(location_id),
        int(data["product_id"])
        )
    result = {'product_lot': response}
    response = {
        "status": 200,
        "message": result
        }
    return jsonify(response)


@api.route('/stocks/validate/<string:request_id>', methods=['POST'])
def validate(request_id):
    picking = PickingRequest(int(request_id))
    response = picking.validate()

    return jsonify(response)


@api.route('/stocks/cancel/<string:request_id>', methods=['POST'])
def cancel(request_id):
    picking = PickingRequest(int(request_id))
    response = picking.cancel()
    if response:
        response = {
            "status": 200,
            "message": "Ok"
            }
    else:
        response = {
            "status": 500,
            "message": "Ko"
            }

    return jsonify(response)


# EOF
