# -*- coding: utf-8 -*-

import re
import requests
import datetime
from xmlrpc import client
from .consts import (
    LOGIN_ODOO,
    ODOO_URI,
    db,
    username,
    password
    )


class Attendance(object):

    def __init__(self, employee_id, check_in, check_out):

        self.employee_id = employee_id
        self.check_in = check_in
        self.check_out = check_out

    def create(self):
        params = {
            "jsonrpc": "2.0",
            "params": {
                "vals": {
                    "employee_id": self.employee_id,
                    "check_in": self.check_in
                }
            }
        }
        session = requests.Session()
        session.post(
             '{}/web/session/authenticate'.format(ODOO_URI),
             json=LOGIN_ODOO
             )
        response = session.post(
            '{uri}/api/v1/attendances/'.format(uri=ODOO_URI),
            json=params
            )
        response = response.json()
        return response['result']['attendance_id']


def get_data(lines):
    data = [
        [(
            (re.split("[A-z]+", line[25:49]))[0]
            ).replace(" ", ""), line[50:66]]
        for line in lines if (re.split("[A-z]+", line[25:49]))[0]
        ]
    return data


def get_matricule(data):
    matricules = set([i[0] for i in data])
    return matricules


def plus_une_minute(date):
    date = datetime.datetime.strptime(date, "%d/%m/%Y %H:%M")
    une_minute = datetime.timedelta(hours=0, minutes=1)
    date = date + une_minute
    return date.strftime("%d/%m/%Y, %H:%M")


def moins_une_minute(date):
    date = datetime.datetime.strptime(date, "%d/%m/%Y %H:%M")
    une_minute = datetime.timedelta(hours=0, minutes=1)
    date = date - une_minute
    return date.strftime("%d/%m/%Y, %H:%M")


def get_employee_id(registration_number):

    common = client.ServerProxy(
        '{}/xmlrpc/2/common'.format(ODOO_URI)
        )
    uid = common.authenticate(
        db,
        username,
        password,
        {}
        )
    models = client.ServerProxy('{}/xmlrpc/2/object'.format(ODOO_URI))

    record = models.execute_kw(
                    db,
                    uid,
                    password,
                    'hr.employee',
                    'search_read',
                    [
                        [
                            ['number', '=', registration_number]
                        ]
                    ],
                    {'fields': ['id']}
                )
    return record[0]['id']

# EOF
