# SimBank Services

Cette application permet d'envoyer des SMS via le Simbank

## Pré-requis

L'application ne fonctionne qu'en Python3.x et requiert les paquets suivants:

* click

* pika

* redis

* blueflask

* to_log

## Installation

```
$ pip3 install -i http://miroir.blueline.mg/pypi simbank-services
```

L'application est installée:

 * vous pouvez importer le module depuis votre PYTHON_PATH
 * vous pouvez exécuter la commande _simbank-services_ qui a été installée


## Configuration

Avant toute utilisation, vous devez configurer en créant un fichier de configuration
dans `/etc/simbank-services/simbank-services.conf`.

Ce fichier est un fichier .INI qui devra se présenter comme suit:

```INI
[API]
url = url_de_l'_api_du_simbank-services
password = mot_de_passe

[APP]
service_code = le_code_du_service_pour_personnaliser_les_erreurs

[LOGS]
filename = /var/log/simbank-services/simbank-services.log
level = DEBUG

[SIM_SLOTS]  # liste des numéros par slot
```

> le dossier de LOGS doit être créé au préalable


## Utilisation

### CLI

Lors de l'installation une interface en ligne de commande, appelée _simbank-services_ a été installée.

Vous pouvez, à partir de cette interface, envoyer un SMS à un numéro

 ```bash
 $ simbank-services send_to 0390390018 --msg /path/to/file --source <sim_slot>
 ```

### API REST

Pour accéder à la documentation, lancez l'API

```
$ simbank-services runserver --host 127.0.0.1 --port 5000
```

Puis, dans votre navigateur, vous pouvez visiter http://127.0.0.1:5000/api
