#!/usr/bin/env python
# encoding: utf-8

from ..amqp_worker import process, Worker
from ..core import Sms
from . import app

import configparser

import click


@click.group()
def cmd():
    pass


@cmd.command()
@click.argument('queue')
@click.option('--workers', type=int, default=1)
def async_daemon(queue, workers):
    """Lance un ou plusieurs workers pour une file d'attente"""

    if not workers:
        click.echo("Il me faut au moins un worker")
    elif workers == 1:
        process(queue)
    else:
        threads = [
            Worker('worker-{}'.format(i), queue)
            for i in range(workers)
            ]
        for thread in threads:
            thread.start()


@cmd.command()
@click.argument('destination')
@click.option('--msg', default='Test')
@click.option('--source', default=None)
def send_to(destination, msg, source):
    """Envoi d'un SMS"""
    try:
        obj = Sms(destination, msg, source)
    except configparser.NoOptionError:
        click.echo("Le numéro source indiqué n'existe pas dans le SIMBank")
    else:
        status, content = obj.send()
        click.echo(content)


@cmd.command()
@click.option('--host', default='127.0.0.1')
@click.option('--port', default=5000)
def runserver(host, port):
    app.run(
        host=host,
        port=port,
        debug=True
        )
