#!/usr/bin/env python
# encoding: utf-8

"""
Gestion des erreurs de l'API
"""

from blueflask.lib.errors import HTTPError
from ..consts import SERVICE_CODE


ERRORS = {
    4000: (400, "numéro de téléphone incorrect"),
    4001: (400, "message vide"),
    4002: (400, "valeur inconnue pour le paramètre 'simulation'"),
    5000: (500, "serveur RabbitMQ de l'application injoignable"),
    5003: (503, "erreur de connexion au simbank"),
    5004: (504, "simbank trop lent à répondre")
    }


def error(code, message=None):
    return HTTPError(ERRORS[code][0]).response(
        message=message or ERRORS[code][1],
        code='{service_code}-{code}'.format(
            service_code=SERVICE_CODE,
            code=code
            ),
        service_code=SERVICE_CODE,
        )
