# -*- coding: utf-8 -*-

from flask import Blueprint, request

from blueflask.lib.errors import forbidden, internal_error, not_allowed
from blueflask.lib.errors import not_found
from blueflask.lib.errors import unauthorized

from ...consts import SERVICE_CODE

import traceback


api = Blueprint('api', __name__, url_prefix='/api/v1')
__version__ = '1.0'


@api.errorhandler(401)
def unauthorized_error(e):
    return unauthorized(
        service_code=SERVICE_CODE,
        request_id=request.headers.get('X-Request-Id')
        )


@api.errorhandler(403)
def forbidden_error(e):
    return forbidden(
        service_code=SERVICE_CODE,
        request_id=request.headers.get('X-Request-Id')
        )


@api.errorhandler(404)
def not_found_error(e):
    return not_found(
        service_code=SERVICE_CODE,
        request_id=request.headers.get('X-Request-Id')
        )


@api.errorhandler(405)
def method_not_allowed_error(e):
    return not_allowed(
        service_code=SERVICE_CODE,
        request_id=request.headers.get('X-Request-Id')
        )


@api.errorhandler(500)
def internal_server_error(e):
    message = {
        'error': str(e),
        'traceback': ''.join(traceback.format_tb(e.__traceback__))
        }
    return internal_error(
        message,
        service_code=SERVICE_CODE,
        request_id=request.headers.get('X-Request-Id')
        )


from . import sms  # NOQA

# EOF
