#!/usr/bin/env python
# encoding: utf-8

from flask import Blueprint, request

from blueflask.lib.errors import internal_error
from blueflask.lib.errors import not_allowed, not_found, unauthorized

__version__ = '1.0'

api = Blueprint('api', __name__, url_prefix='/api/v1')


@api.errorhandler(401)
def unauthorized_error(e):
    return unauthorized(
        message='token expiré',
        code='040-05-401',
        request_id=request.headers.get('X-Request-Id')
        )


@api.errorhandler(404)
def not_found_error(e):
    return not_found(
        message='ressource introuvable',
        code='040-05-404',
        request_id=request.headers.get('X-Request-Id')
        )


@api.errorhandler(405)
def method_not_allowed_error(e):
    return not_allowed(
        message='action non autorisée',
        code='040-05-405',
        request_id=request.headers.get('X-Request-Id')
        )


@api.errorhandler(500)
def internal_server_error(e):
    return internal_error(
        message='erreur inconnue',
        code='040-05-500',
        request_id=request.headers.get('X-Request-Id')
        )

from . import clients  # NOQA

# EOF
