#!/usr/bin/env python
# encoding: utf-8
import functools


SERVICE_CODE = '040-05'


def check_parameters(arg1=None, arg2=None, arg3=None, arg4=None, arg5=None):
    """
    Décorateur prenant des arguments qui représentent
    les paramètres nommés attendus dans la signature
    de la fonction
    """

    def decorated(func):
        @functools.wraps(func)
        def wrapper(*args, **kwargs):
            mandatory_keys = [
                'operator',
                'service_type',
                'request',
                arg1,
                arg2,
                arg3,
                arg4
                ]
            mandatory_keys = [i for i in mandatory_keys if i]
            for item in mandatory_keys:
                if item not in kwargs:
                    raise SyntaxError(
                        "L'argument '{arg}' est introuvable".format(arg=item)
                        )
            return func(*args, **kwargs)
        return wrapper
    return decorated
